IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_CREDIARIO_FECHA_POSICAO_FINANCEIRA_PROC')
BEGIN
	DROP TRIGGER TRG_RC_CREDIARIO_FECHA_POSICAO_FINANCEIRA_PROC
END
GO
CREATE TRIGGER [dbo].[TRG_RC_CREDIARIO_FECHA_POSICAO_FINANCEIRA_PROC] ON [dbo].[RC_CREDIARIO_FECHA] 
FOR INSERT, UPDATE
AS
--Controle de posicao financeira
if exists (select p.cd_emp
				FROM
					RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_FECHA p with (nolock)
					INNER JOIN INSERTED i ON
					p.CD_EMP = 1 AND
					p.CD_FILIAL = 0
				WHERE
					p.DT_PROC >= CONVERT(DATE,i.DT_CAD) )
	begin
		DELETE 
			P
		FROM
			RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_FECHA p 
			INNER JOIN INSERTED i ON
			p.CD_EMP = 1 AND
			p.CD_FILIAL = 0
		WHERE
			p.DT_PROC >= CONVERT(DATE,i.DT_CAD);
	end
	
--Caso nao tenha cadastre
	INSERT INTO RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_FECHA (CD_EMP, CD_FILIAL, DT_PROC, DT_CAD)
	SELECT DISTINCT 
		1,
		0,
		MIN(CONVERT(DATE,i.DT_CAD)),
		GETDATE()
	FROM
		INSERTED I